if (debug==0)
   environment noecho
end if

compute lfprdatafile = "input.db"
compute ssmdatafile = "cpscovar_rev.db"
compute lfproutfile = "/mcr/home/m1fxg00/lfpr_run"+%string(runno)+".db"
compute tempfile = "/tmp/scalarout_run"+%string(runno)+".inp"
compute tempfile2 = "/tmp/scalarout2_run"+%string(runno)+".inp"
compute tempfile3 = "/tmp/scalarout3_run"+%string(runno)+".inp"

compute [vect[str]] genders =   ||'f','m'||
compute [vect[str]] gendertitle =   ||'Female','Male'||

   ** upe = lf participation series (UE/POP+EMP/POP)
   ** gs   = population share w/in sex series (using cps second-stage weights)
   ** ts = population share of total (using cps second-stage weights)
   ** pop = total population count (using cps second-stage weights)


*********************************************************************
** OUTPUT THE RUN INFORMATION
*********************************************************************
** IF AN OUTPUT DATABASE ASSOCIATED WITH THE RUN NUMBER EXISTS, REMOVE IT
dos "rm -f "+lfproutfile
dos "rm -f "+tempfile

open fameout &tempfile
display(unit=fameout) "open <ac create> "+'"'+lfproutfile+'"'+" as lout"
display(unit=fameout) "over on; case 1 to *"

display(unit=fameout) "series lout'vars,lout'vardesc:string by case"
display(unit=fameout) "series lout'vartype,lout'varsex,lout'varnorm,lout'varcyc,lout'varstage,lout'varlagged:numeric by case"
dofor r = 1 to %rows(rhsvar)
   display(unit=fameout) "set lout'vars["+r+'] = "'+rhsvar(r)+'"'
   display(unit=fameout) "set lout'vardesc["+r+'] = "'+rhsdesc(r)+'"'
   display(unit=fameout) "set lout'vartype["+r+'] = '+%string(rhsvartype(r))
   display(unit=fameout) "set lout'varsex["+r+'] = '+%string(rhsvarsex(r))
   display(unit=fameout) "set lout'varnorm["+r+'] = '+%string(rhsvarnorm(r))
   display(unit=fameout) "set lout'varcyc["+r+'] = '+%string(rhsvarcyc(r))
   display(unit=fameout) "set lout'varstage["+r+'] = '+%string(rhsvarstage(r))
   display(unit=fameout) "set lout'varlagged["+r+'] = '+%string(rhslagl(r)(1)<>0)

   if (rhslagl(r)(1)<>0)
   {
      display(unit=fameout) "series lout'v"+r+"_lags:numeric by case"
      dofor l = 1 to %rows(rhslagl(r))
         display(unit=fameout) "set lout'v"+r+"_lags["+l+'] = '+%string(rhslagl(r)(l))
      end dofor
      display(unit=fameout) " "
   }
end dofor
display(unit=fameout) " "

dofor r = 1 to %rows(fsv)
   display(unit=fameout) "-lout'start_est."+fsv(r)+" = make(date("+fsv(r)+'),"'+syearv(r)+":"+sperv(r)+'")'
   display(unit=fameout) "-lout'end_est."+fsv(r)+" = make(date("+fsv(r)+'),"'+eyearv(r)+":"+eperv(r)+'")'
   display(unit=fameout) "-lout'end_frcst."+fsv(r)+" = make(date("+fsv(r)+'),"'+feyearv(r)+":"+feperv(r)+'")'
end dofor
display(unit=fameout) " "

display(unit=fameout) "-lout'ae_poly_degree = "+ae_poly_degree
display(unit=fameout) "-lout'ce_poly_degree = "+ce_poly_degree
display(unit=fameout) "-lout'x_cohorts_beg = "+x_cohorts_beg
display(unit=fameout) "-lout'x_cohorts_end = "+x_cohorts_end
display(unit=fameout) "-lout'reg_cohort_num = "+reg_cohort_num
display(unit=fameout) "-lout'cohort_ex = "+cohort_ex
display(unit=fameout) "-lout'weighted = "+weighted
display(unit=fameout) "-lout'smoothed = "+smoothed
display(unit=fameout) "-lout'errmod = "+errmod

display(unit=fameout) "-lout'lfpname = "+'"'+stypes(1)+'"'

display(unit=fameout) "-lout'runtime = thisday(minutely)" 
display(unit=fameout) "close lout"
display(unit=fameout) "exit"

close fameout

dos "fame -fame i "+tempfile

*dos "rm -f "+tempfile

*********************************************************************
*********************************************************************


display ''; display 'STARTING MAIN CODE LOOP'; display ''

*********************************************************************
** START MAIN CODE LOOP
*********************************************************************
*********************************************************************

dofor f=1 to %rows(fsv)

   compute [str] fs = fsv(f)
   compute [int] npers = npersv(f)
   compute [int] syear = syearv(f)
   compute [int] sper = sperv(f)
   compute [int] eyear = eyearv(f)
   compute [int] eper = eperv(f)

   compute [int] fyear = feyearv(f)
   compute [int] fper = feperv(f)

   compute [int] firstcohort = syear-allages(%rows(allages))-fix(%if(smoothed == 1,1,0))
   compute [int] lastcohort  = fyear-allages(1)
   compute [int] frcstcohorts = fyear-eyear


   *********************************************************************
   ** SET UP AGE EFFECT AND COHORT EFFECT RESTRICTIONS
   *********************************************************************
   declare rect AER CER
   if (ae_poly_degree<0)
   {
      ** no restrictions on age coefficients (use 'identity' restriction)
      compute AER = %identity(64);
   }
   else 
   {
      ** polynomial restriction on ae's
      dim AER(ae_poly_degree+1,64)
      ewise AER(i,j) = j**(i-1)
   }

   if (ce_poly_degree<0)
   {
      ** set cohort effect to zero for people born in 1975
      dim CER(lastcohort-firstcohort,lastcohort-firstcohort+1)
      ewise CER(i,j) = %if((i<=(1975-firstcohort)),%if(j==i,1,0),%if(j==(i+1),1,0))
   }
   else
   {
      ** polynomial constraint on ces
      dim CER(ce_poly_degree+1,lastcohort-firstcohort+1)
      ewise CER(i,j) = j**(i-1)
   }

   *********************************************************************
   *********************************************************************

   ** COMPUTE START OFFSET REQUIRED TO ACCOMODATE MAXIMUM SPECIFIED LAG
   compute max_lag = 0
   dofor r = 1 to %rows(rhsvar)
      dofor l = 1 to %rows(rhslagl(r))
         if(rhslagl(r)(l)>max_lag)
         {
            compute max_lag = fix(rhslagl(r)(l))
         }
      end dofor
   end dofor
   display "maxlags: " ## max_lag

   compute [int] lag_pers = fix(max_lag * npers/12)
   compute [int] syear_lags = syear-fix(lag_pers/npers)
   compute [int] lag_pers = %mod(lag_pers,npers)
   compute [int] syear_lags = fix(%if(lag_pers>=sper,(syear_lags-1),syear_lags))
   compute [int] sper_lags = %clock(sper-lag_pers,npers)

   compute pnobs_lags = npers*(fyear-syear_lags)+fper-(sper_lags-1) 
   compute pnobs = npers*(eyear-syear)+eper-(sper-1) 

   calendar(panelobs=pnobs_lags) syear_lags sper_lags npers
   allocate 64//fyear:fper
   compute panel_cal_lags = %calendar()

   smpl
   clear panelsmpl_f panelsmpl_1 panelsmpl_1e lpanelsmpl_f panelsmpl_e
   set panelsmpl_f = %period(t)>=syear:sper.and.%period(t)<=fyear:fper
   set panelsmpl_1 = %period(t)>=syear:sper.and.%period(t)<=fyear:fper.and.(%indiv(t)==1)
   set panelsmpl_1e = %period(t)>=syear:sper.and.%period(t)<=eyear:eper.and.(%indiv(t)==1)
   set panelsmpl_e = %period(t)>=syear:sper.and.%period(t)<=eyear:eper
   set lpanelsmpl_f = %period(t)>=syear_lags:sper_lags.and.%period(t)<=fyear:fper

   * READ IN RHS VARIABLES AND CREATE REGRESSION LISTS (FOR MEN & WOMEN)
   display ' '; display 'READING IN RHS VARIABLES AND CREATING REGRESSION LISTS...'; display '';

   compute reglistm = %rlempty()
   compute reglistf = %rlempty()
   compute reglistm2 = %rlempty()
   compute reglistf2 = %rlempty()
   compute dostage2 = 0;

   open data &lfprdatafile

   decl vect[int] stage2agem(%rows(allages)); ewise stage2agem(i)=0
   decl vect[int] stage2agef(%rows(allages)); ewise stage2agef(i)=0
   dofor r = 1 to %rows(rhsvar)
      display ' '; display 'PROCESSING VARIABLE '+%string(r)+' of '+%string(%rows(rhsvar))+'...';
      display "   SETTING UP PANEL..."
      if ((rhsvartype(r)==0).or.(rhsvartype(r)==2))
      {
         * READ IN VARIABLE
         clear %s(rhsvar(r)+'_'+fs)
         data(format=fame) 1//syear_lags:sper_lags 1//fyear:fper %s(rhsvar(r)+'_'+fs)
      
         * NORMALIZE IF REQUESTED
         if ((rhsvarnorm(r)==1).or.(rhsvarnorm(r)==2))
         {
            statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_'+fs)
            if (rhsvarnorm(r)==1)
            {
               set %s(rhsvar(r)+'_'+fs) = (%s(rhsvar(r)+'_'+fs)-%mean)/sqrt(%variance)
            }
            else
            {
               set %s(rhsvar(r)+'_'+fs) = (%s(rhsvar(r)+'_'+fs)-%mean)
            }
            statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_'+fs)
         }

         * BUILD PANEL VARIABLE
         clear %s(rhsvar(r)+'p')
         smpl(series=lpanelsmpl_f); set %s(rhsvar(r)+'p') = 0.0; smpl
         dofor a=16 to 79
            do ti=syear_lags:sper_lags,fyear:fper
               compute %s(rhsvar(r)+'p')((a-15)//ti) = %s(rhsvar(r)+'_'+fs)(1//ti)
            end do
         end do
      }
      else if ((rhsvartype(r)==1).or.(rhsvartype(r)==3))
      {
         clear %s(rhsvar(r)+'p')
         smpl(series=lpanelsmpl_f); set %s(rhsvar(r)+'p') = 0.0; smpl
         * FOR EACH AGE
         dofor a = 1 to %rows(rhsages(r))
            * READ IN VARIABLE
            clear %s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs)
            data(format=fame) 1//syear_lags:sper_lags 1//fyear:fper %s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs)

            * NORMALIZE IF REQUESTED
            if ((rhsvarnorm(r)==1).or.(rhsvarnorm(r)==2))
            {
               statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs)
               if (rhsvarnorm(r)==1)
               {
                  set %s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs) = (%s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs)-%mean)/sqrt(%variance)
               }
               else
               {
                  set %s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs) = (%s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs)-%mean)
               }
               statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs)
            }

            * ADD TO PANEL VARIABLE
            do ti=syear_lags:sper_lags,fyear:fper
               compute %s(rhsvar(r)+'p')(((rhsages(r)(a))-15)//ti) = %s(rhsvar(r)+'_a'+rhsages(r)(a)+'_'+fs)(1//ti)
            end do
 
         end dofor
      }
      else if (rhsvartype(r)==4)
      {
         * FOR EACH SEX
         dofor s = 1 to 2
            if ((rhsvarsex(r)==0).or.(s==rhsvarsex(r)))
            {
               clear %s(rhsvar(r)+genders(s)+'p')
               smpl(series=lpanelsmpl_f); set %s(rhsvar(r)+genders(s)+'p') = 0.0; smpl
               * FOR EACH AGE
               dofor a = 1 to %rows(rhsages(r))
                  * READ IN VARIABLE
                  clear %s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs)
                  data(format=fame) 1//syear_lags:sper_lags 1//fyear:fper %s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs)

                  * NORMALIZE IF REQUESTED
                  if ((rhsvarnorm(r)==1).or.(rhsvarnorm(r)==2))
                  {
                     statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs)
                     if (rhsvarnorm(r)==1)
                     {
                        set %s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs) = (%s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs)-%mean)/sqrt(%variance)
                     }
                     else
                     {
                        set %s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs) = (%s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs)-%mean)
                     }
                     statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs)
                  }
       
                  * ADD TO PANEL VARIABLE
                  do ti=syear_lags:sper_lags,fyear:fper
                     compute %s(rhsvar(r)+genders(s)+'p')(((rhsages(r)(a))-15)//ti) = %s(rhsvar(r)+'_a'+rhsages(r)(a)+genders(s)+'_'+fs)(1//ti)
                  end do
               end dofor
            }
         end dofor
      }
      else if (rhsvartype(r)==5)
      {
         * FOR EACH SEX
         dofor s = 1 to 2
            if ((rhsvarsex(r)==0).or.(s==rhsvarsex(r)))
            {
               * READ IN VARIABLE
               clear %s(rhsvar(r)+'_'+genders(s)+'_'+fs)
               data(format=fame) 1//syear_lags:sper_lags 1//fyear:fper %s(rhsvar(r)+'_'+genders(s)+'_'+fs)
      
               * NORMALIZE IF REQUESTED
               if ((rhsvarnorm(r)==1).or.(rhsvarnorm(r)==2))
               {
                  statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_'+genders(s)+'_'+fs)
                  if (rhsvarnorm(r)==1)
                  {
                     set %s(rhsvar(r)+'_'+genders(s)+'_'+fs) = (%s(rhsvar(r)+'_'+genders(s)+'_'+fs)-%mean)/sqrt(%variance)
                  }
                  else
                  {
                     set %s(rhsvar(r)+'_'+genders(s)+'_'+fs) = (%s(rhsvar(r)+'_'+genders(s)+'_'+fs)-%mean)
                  }
                  statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_'+genders(s)+'_'+fs)
               }

               * BUILD PANEL VARIABLE
               clear %s(rhsvar(r)+genders(s)+'p')
               smpl(series=lpanelsmpl_f); set %s(rhsvar(r)+genders(s)+'p') = 0.0; smpl
               dofor a = 1 to %rows(rhsages(r))
                  do ti=syear_lags:sper_lags,fyear:fper
                     compute %s(rhsvar(r)+genders(s)+'p')(((rhsages(r)(a))-15)//ti) = %s(rhsvar(r)+'_'+genders(s)+'_'+fs)(1//ti)
                  end do
               end dofor
            }
         end dofor
      }
      else if (rhsvartype(r)==6)
      {
         * FOR EACH SEX
         dofor s = 1 to 2
            if ((rhsvarsex(r)==0).or.(s==rhsvarsex(r)))
            {
               clear %s(rhsvar(r)+genders(s)+'p')
               smpl(series=lpanelsmpl_f); set %s(rhsvar(r)+genders(s)+'p') = 0.0; smpl
               * FOR EACH AGE
               dofor g = 1 to %rows(rhsages(r))/2
                  dofor a = rhsages(r)(2*g-1) to rhsages(r)(2*g)
                     * READ IN VARIABLE
                     clear %s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs)
                     data(format=fame) 1//syear_lags:sper_lags 1//fyear:fper %s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs)

                     * NORMALIZE IF REQUESTED
                     if ((rhsvarnorm(r)==1).or.(rhsvarnorm(r)==2))
                     {
                        statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs)
                        if (rhsvarnorm(r)==1)
                        {
                           set %s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs) = (%s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs)-%mean)/sqrt(%variance)
                        }
                        else
                        {
                           set %s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs) = (%s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs)-%mean)
                        }
                        statistics(noprint,nofractiles,smpl=panelsmpl_1e) %s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs)
                     }
       
                     * ADD TO PANEL VARIABLE
                     do ti=syear_lags:sper_lags,fyear:fper
                        compute %s(rhsvar(r)+genders(s)+'p')((a-15)//ti) = %s(rhsvar(r)+'_a'+a+genders(s)+'_'+fs)(1//ti)
                     end do
                  end dofor
               end dofor
            }
         end dofor
      }
 

      * COMPUTE LAGS IF REQUESTED
      if (rhslagl(r)(1)!=0);
      {
         display "   COMPUTING LAGS..."
         if ((rhsvartype(r)==4).or.(rhsvartype(r)==5).or.(rhsvartype(r)==6))
         {
            dofor s= 1 to 2
               if ((rhsvarsex(r)==0).or.(s==rhsvarsex(r)))
               {
                  dofor l=1 to %rows(rhslagl(r))
                     clear %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+genders(s)+'p')
                     set %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+genders(s)+'p') = %s(rhsvar(r)+genders(s)+'p'){fix((rhslagl(r)(l))*npers/12)}
                  end dofor
               }
            end dofor
         }
         else
         {
            dofor l=1 to %rows(rhslagl(r))
               clear %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'p')
               set %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'p') = %s(rhsvar(r)+'p'){fix((rhslagl(r)(l))*npers/12)}
            end dofor
         }
      }

      display "   ADDING TO REGRESSION LIST..."
      * ADD TO REGRESSION LIST
      dofor s = 1 to 2
         if ((rhsvarsex(r)==0).or.(s==rhsvarsex(r)))
         {
            compute reglisttmp = %rlempty()
            if (rhsvartype(r)==2)
            {
               * IF VARIABLE TYPE 2 COEFFICIENTS VARY BY AGE GROUP
               dofor a = 1 to %rows(rhsages(r))/2
                  set %s(rhsvar(r)+'_a'+fix((rhsages(r)(2*a-1)))+'_'+fs) = $
                      ((%indiv(t)>=(rhsages(r)(2*a-1)-15)).and.(%indiv(t)<=(rhsages(r)(2*a)-15)))*%s(rhsvar(r)+'p')
                  compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+'_a'+fix(rhsages(r)(2*a-1))+'_'+fs))
                  if ((rhslagl(r)(1))<>0)
                  {
                     dofor l=1 to %rows(rhslagl(r))
                        set %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(2*a-1))+'_'+fs) = $
                            ((%indiv(t)>=(rhsages(r)(2*a-1)-15)).and.(%indiv(t)<=(rhsages(r)(2*a)-15)))*%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'p')
                        compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(2*a-1))+'_'+fs))
                     end dofor
                  }
               end dofor
            }
            else if (rhsvartype(r)==3)
            {
               * FOR TYPE 3 VARIABLES, COEFFICIENTS DO NOT VARY BY
               * AGE SO ONLY REQUIRE ONE PANEL VARIABLE IN THE REGRESSION
               * + 1 PANEL VARIABLE PER LAG
               compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+'p'))
               if ((rhslagl(r)(1))!=0)
               {
                  dofor l=1 to %rows(rhslagl(r))
                     compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'p'))
                  end dofor
               }
            }
            else if ((rhsvartype(r)==0).or.(rhsvartype(r)==1))
            {
               * IF VARIABLE TYPE 0 or 1 COEFFICIENTS VARY BY AGE SO NEED TO CREATE
               * AGE SPECIFIC PANEL VARS
               dofor a = 1 to %rows(rhsages(r))
                  set %s(rhsvar(r)+'_a'+fix((rhsages(r)(a)))+'_'+fs) = (%indiv(t)==((rhsages(r)(a))-15))*%s(rhsvar(r)+'p')
                  compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+'_a'+fix((rhsages(r)(a)))+'_'+fs))
                  if ((rhslagl(r)(1))<>0)
                  {
                     dofor l=1 to %rows(rhslagl(r))
                        set %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(a))+'_'+fs) = $
                            (%indiv(t)==((rhsages(r)(a))-15))*%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'p')
                        compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(a))+'_'+fs))
                     end dofor
                  }
               end dofor
            }
            else if ((rhsvartype(r)==4).or.(rhsvartype(r)==5))
            {
               * IF VARIABLE TYPE 4 OR 5, COEFFICIENTS VARY BY AGE-SEX GROUP SO NEED TO CREATE
               * AGE-SEX SPECIFIC PANEL VARS
               dofor a = 1 to %rows(rhsages(r))
                  set %s(rhsvar(r)+'_a'+fix((rhsages(r)(a)))+genders(s)+'_'+fs) = (%indiv(t)==((rhsages(r)(a))-15))*%s(rhsvar(r)+genders(s)+'p')
                  compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+'_a'+fix((rhsages(r)(a)))+genders(s)+'_'+fs))
   
                  if ((rhslagl(r)(1))<>0)
                  {
                     dofor l=1 to %rows(rhslagl(r))
                        set %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(a))+genders(s)+'_'+fs) = $
                            (%indiv(t)==((rhsages(r)(a))-15))*%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+genders(s)+'p')
                        compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(a))+genders(s)+'_'+fs))
                     end dofor
                  }
               end dofor
            }
            else if (rhsvartype(r)==6)
            {
               * IF VARIABLE TYPE 0 or 1 COEFFICIENTS VARY BY AGE SO NEED TO CREATE
               * AGE SPECIFIC PANEL VARS
               dofor a = 1 to %rows(rhsages(r))/2
                  set %s(rhsvar(r)+'_a'+fix((rhsages(r)(2*a-1)))+'_'+fs) = $
                      ((%indiv(t)>=(rhsages(r)(2*a-1)-15)).and.(%indiv(t)<=(rhsages(r)(2*a)-15)))*%s(rhsvar(r)+genders(s)+'p')
                  compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+'_a'+fix(rhsages(r)(2*a-1))+'_'+fs))
                  if ((rhslagl(r)(1))<>0)
                  {
                     dofor l=1 to %rows(rhslagl(r))
                        set %s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(2*a-1))+genders(s)+'_'+fs) = $
                            (%indiv(t)==((rhsages(r)(2*a-1))-15).and.(%indiv(t)<=(rhsages(r)(2*a)-15)))*%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+genders(s)+'p')
                        compute reglisttmp = %rladdone(reglisttmp,%s(rhsvar(r)+fix((rhslagl(r)(l))*npers/12)+'_a'+fix(rhsages(r)(2*a-1))+genders(s)+'_'+fs))
                     end dofor
                  }
               end dofor
            }

            if (rhsvarstage(r)==1)
            {
               if (s==1); compute reglistf = %rlconcat(reglistf,reglisttmp);
               else; compute reglistm = %rlconcat(reglistm,reglisttmp);
            }
            else if (rhsvarstage(r)==2)
            {
               if (s==1)
               {
                  compute reglistf2 = %rlconcat(reglistf2,reglisttmp);
                  ** UPDATE LIST OF SECOND STAGE AGES
                  dofor i=1 to %rows(allages)
                     dofor j=1 to %rows(rhsages(r))
                        if (rhsages(r)(j)==allages(i))
                        {
                           compute stage2agef(i) = 1
                        }
                     end dofor
                  end dofor
               }
               else
               {
                  compute reglistm2 = %rlconcat(reglistm2,reglisttmp);
                  dofor i=1 to %rows(allages)
                     dofor j=1 to %rows(rhsages(r))
                        if (rhsages(r)(j)==allages(i))
                        {
                           compute stage2agem(i) = 1
                        }
                     end dofor
                  end dofor
               }                  
               compute dostage2 = 1;
            }
         }
      end dofor

   end dofor

   close data

   ** READ IN LFPR AND POPULATION SERIES (DEFINED IN STYPES VECTOR)
   display " "; display "READING IN LFPR AND POPULATION SERIES..."; display " ";

   show memory
   do i = 1,5
      do j = 1,2
         do k = 1,64
            clear %s(stypes(i)+genders(j)+'_a'+allages(k))
         end do
      end do
   end do
   show memory

   ** The following statement doesn't print anything but added it so that;
   ** the open statement below wouldn't seg fault -- sometimes Rats is pretty strange;
   ** (maybe it's a timing issue?);
   ** print / %s(stypes(5)+genders(2)+'_a'+allages(64))
   ** print / %s(stypes(1)+genders(1)+'_a'+allages(1))
   display " "; display "READING FROM FILE "+&ssmdatafile+"..."; display " ";
   open data &ssmdatafile
      data(format=fame) 1//syear:sper 1//fyear:fper $
         %s(stypes(1)+genders(1)+'_a'+allages(1)) to %s(stypes(5)+genders(2)+'_a'+allages(64)) 
   close data
   display " "; display "DONE."; display " ";

   ** FORM PANEL SERIES FOR LFPR AND POPULATION SERIES
   display ' '; display 'FORMING PANEL SERIES...'; display '';
   do i = 1,5
      do j = 1,2
         ** CREATE SERIES COPY OF SERIES TO WRITE TO OUTPUT DATA SET
         do k = 1,64
            set %s(stypes(i)+genders(j)+allages(k)+fs) = %s(stypes(i)+genders(j)+'_a'+allages(k))
         end do

         open(append) copy &lfproutfile
            copy(format=fame) 1//syear:sper 1//fyear:fper $
            %s(stypes(i)+genders(j)+'16'+fs) to %s(stypes(i)+genders(j)+'79'+fs)
         close copy
         *release %s('r'+runno+'_'+stypes(i)+genders(j)+'16'+fs) to %s('r'+runno+'_'+stypes(i)+genders(j)+'79'+fs)

         pform %s(stypes(i)+genders(j)+'p') 1//syear_lags:sper_lags 1//fyear:fper 
         # %s(stypes(i)+genders(j)+'_a16') to %s(stypes(i)+genders(j)+'_a79')
      end do
   end do

   ** APPLY TRANSFORMATION TO LFPR SERIES
   if (logit == 1)
   {
      set %s('ln'+stypes(1)+'fp') = log(%s(stypes(1)+'fp')/(1-%s(stypes(1)+'fp')))
      set %s('ln'+stypes(1)+'mp') = log(%s(stypes(1)+'mp')/(1-%s(stypes(1)+'mp')))
   }
   else 
   {
      set %s('ln'+stypes(1)+'fp') = %s(stypes(1)+'fp')
      set %s('ln'+stypes(1)+'mp') = %s(stypes(1)+'mp')
   }

   **************************************************************************
   **************************************************************************
   ** DEFINE AGE AND COHORT DUMMY VARIABLES
   **************************************************************************
   display ' '; display 'DEFINING AGE AND COHORT DUMMY VARIABLES...'; display '';

   do i = 1,64
      clear %s('age_'+allages(i)+'_'+fs)
      set %s('age_'+allages(i)+'_'+fs) = (i==%indiv(t))
   end do

   * ADD AGE REGRESSIONS TO SECOND STAGE REGRESSION IF INTERCEPT TERM WAS REQUESTED
   * FOR THE SECOND STAGE REGRESSION
   if ((dostage2==1).and.(stage2int==1))
   {
      dofor i=1 to %rows(allages)
         if (stage2agem(i)==1)
         {
            compute reglistm2 = %rladdone(reglistm2,%s('age_'+allages(i)+'_'+fs))
         }
         if (stage2agef(i)==1)
         {
            compute reglistf2 = %rladdone(reglistf2,%s('age_'+allages(i)+'_'+fs))
         }
      end dofor
   }

   if (smoothed == 1)
   {
      do cohort_year = firstcohort,lastcohort
         clear %s('c_'+cohort_year)
         set %s('c_'+cohort_year) = %if(%year(t)-cohort_year==(%indiv(t)+15), $
                                        (2.0*%month(t)-1)/(npers*2.0), $
                                        %if(%year(t)-cohort_year==(%indiv(t)+15+1), $
                                            (npers*2.0+1-2*%month(t))/(npers*2.0), $
                                            0))
      end do
      if (debug==1)
      {
         print / %s('c_1903') to %s('c_1909')
      }
   }
   else
   {
      do cohort_year = firstcohort,lastcohort
         clear %s('c_'+cohort_year)
         set %s('c_'+cohort_year) = ((%year(t)-cohort_year)==(%indiv(t)+15))
      end do
   }

   **************************************************************************
   **************************************************************************

   **************************************************************************
   **************************************************************************
   * TRIM DATA POINTS & SET UP EFFECT RESTRICTION
   **************************************************************************

   ** REMOVE OBSERVATIONS FOR VERY OLD AND NEW COHORTS TO MITIGATE EFFECTS
   ** OF LIMITED DATA AT THE ENDPOINTS -- ALSO %NAs THE DATA POINTS THAT SHOULD
   ** BE INCLUDED WHEN CONSTRUCTING THE FIT BUT EXCLUDED FOR THE ESTIMATION

   display ' '; display 'ENCODING RESTRICTIONS...'; display '';
   clear boundx
   set boundx = %if(%period(t)>=(eyear:eper), $
                   %NA, $
                   %if(%indiv(t)<=x_cohorts_beg+frcstcohorts, $
                      %if(%period(t)>=(eyear-x_cohorts_beg+%indiv(t)):1, $
                         %NA, $
                         1 $
                      ), $
                      %if(%indiv(t)>=(64-x_cohorts_end+1-fix(%if(smoothed==1,1,0))), $
                         %if(%period(t)<(syear+x_cohorts_end-(64-%indiv(t))+fix(%if(smoothed==1,1,0))):1, $
                            %NA, $
                            1 $
                         ), $
                         1 $
                      ) $
                   ) $
                )
   if (debug==1)
   {
      print / boundx
   }

   * RESTRICTED RANGE USED FOR ESTIMATION
   if (logit==1)
   {
      set %s('ln'+stypes(1)+'fpx') = log(%s(stypes(1)+'fp')/(1-%s(stypes(1)+'fp')))*boundx
      set %s('ln'+stypes(1)+'mpx') = log(%s(stypes(1)+'mp')/(1-%s(stypes(1)+'mp')))*boundx
   }
   else
   {
      set %s('ln'+stypes(1)+'fpx') = %s(stypes(1)+'fp')*boundx
      set %s('ln'+stypes(1)+'mpx') = %s(stypes(1)+'mp')*boundx
   }

   encode(clear,scratch=ae_constr) AER
   # %s('age_16_'+fs) to %s('age_79_'+fs)

   encode(noclear,scratch=ce_constr) CER
   # %s('c_'+firstcohort) to %s('c_'+lastcohort)

   ** FOR EACH GENDER, DO REGRESSION
   do s = 1,2
      **************************************************************************
      **************************************************************************
      ** PERFORM (ENCODED) REGRESSION
      **************************************************************************
   
      *if (weighted==1); set spreads = %s('gs'+genders(s)+'p')/sqrt(%s('upe'+genders(s)+'p')*(1.0-%s('upe'+genders(s)+'p')))
      *else; set spreads = 1.0

      * SET THE APPROPRIATE REGRESSION LIST BASED ON SEX
      if (s==1)
      {  
         compute reglist = reglistf
         compute stage2age = stage2agef
      }
      else
      { 
         compute reglist=reglistm
         compute stage2age = stage2agem
      }
   
      clear %s('spread'+genders(s)+'_'+fs); * %s('varp'+genders(s)+'_'+fs)
      if (weighted==1)
      {
         *set %s('varp'+genders(s)+'_'+fs) = %s('upe'+genders(s)+'p')*(1.0-%s('upe'+genders(s)+'p'))/%s('popn'+genders(s)+'p')
         if (logit==1)
         {
            set %s('spread'+genders(s)+'_'+fs) = 1/(%s(stypes(5)+genders(s)+'p')*%s(stypes(1)+genders(s)+'p')*(1.0-%s(stypes(1)+genders(s)+'p')))
            set %s('spread'+genders(s)+'_p_'+fs) = 1/(%s(stypes(1)+genders(s)+'p')*(1.0-%s(stypes(1)+genders(s)+'p')))
            set %s('spread'+genders(s)+'_n_'+fs) = 1/%s(stypes(5)+genders(s)+'p')
         }
         else
         {
            set %s('spread'+genders(s)+'_'+fs) = (%s(stypes(1)+genders(s)+'p')*(1.0-%s(stypes(1)+genders(s)+'p')))/%s(stypes(5)+genders(s)+'p')
            set %s('spread'+genders(s)+'_p_'+fs) = (%s(stypes(1)+genders(s)+'p')*(1.0-%s(stypes(1)+genders(s)+'p')))
            set %s('spread'+genders(s)+'_n_'+fs) = 1/%s(stypes(5)+genders(s)+'p')
         }
      }
      else; set %s('spread'+genders(s)+'_'+fs) = 1.0

      display ' '; display 'RUNNING REGRESSION FOR GENDER: '+genders(s)+'; FREQUENCY: '+fs; display ' '

      if (errmod==1)
      {
         ar1(smpl=panelsmpl_f, $
             unravel, $
             spread=%s('spread'+genders(s)+'_'+fs)) %s('ln'+stypes(1)+genders(s)+'px') / %s(genders(s)+'arresids_'+fs)
         # reglist ae_constr ce_constr

         prj(smpl=panelsmpl_f) %s('ln'+stypes(1)+'_arfit'+genders(s)+fs)
      }
      else if (errmod==2)
      {
         ar1(smpl=panelsmpl_f, $
             unravel, $
             heterogenous, $
             prhos=%s('prhos'+genders(s)+'_'+fs), $ 
             spread=%s('spread'+genders(s)+'_'+fs)) %s('ln'+stypes(1)+genders(s)+'px') / %s(genders(s)+'arresids_'+fs)
         # reglist ae_constr ce_constr

         prj(smpl=panelsmpl_f) %s('ln'+stypes(1)+'_arfit'+genders(s)+fs)

         if (debug==1)
         {
            print / %s('prhos'+genders(s)+'_'+fs)
         }
      }
      else
      {
         linreg(smpl=panelsmpl_f, $
                robusterrors, lags=12, lwindow=neweywest, $ 
                unravel, $
                spread=%s('spread'+genders(s)+'_'+fs)) %s('ln'+stypes(1)+genders(s)+'px') / %s(genders(s)+'resids_'+fs)
         # reglist ae_constr ce_constr

      }

      **************************************************************************
   
      **************************************************************************
      **************************************************************************
      ** EXTRAPOLATE COHORT EFFECTS (IF NECESSARY)
      **************************************************************************
      compute new_beta = %beta
      compute pre_xx = %xx
      compute pre_stderrs = %stderrs
   
      if ((ce_poly_degree<0).and.((x_cohorts_beg>0).or.(x_cohorts_end>0).or.(fyear>eyear).or.(smoothed==1)))
      {
         display ' '; display 'EXTRAPOLATING COHORT EFFECTS...'; display '';

         if ((cohort_ex==0).or.(cohort_ex==2).or.(smoothed==1)) 
         {   
            if ((x_cohorts_beg>0).or.(smoothed==1))
            {
               do i = 1,reg_cohort_num
                  smpl i i
                  set const = 1
                  set tttrend = i
                  set bval_start = new_beta(%rlcount(reglist)+64+x_cohorts_beg+fix(%if(smoothed==1,1,0))+i)
               end do
   
               linreg bval_start 1 reg_cohort_num 
               # const tttrend
     
               do k = 1,x_cohorts_beg+fix(%if(smoothed == 1,1,0))
                  compute new_beta(%rlcount(reglist)+64+k) = (%beta(1)+%beta(2)*float(k-(x_cohorts_beg+fix(%if(smoothed == 1,1,0)))))
               end do
            }
            if ((x_cohorts_end>0).or.(fyear>eyear))
            {
               do i = 1,reg_cohort_num
                  smpl i i
                  set const = 1
                  set tttrend = i
                  set bval_end = new_beta(%rlcount(reglist)+64+((lastcohort-firstcohort+1)-(x_cohorts_end+frcstcohorts+reg_cohort_num-i)))
               end do

               linreg bval_end 1 reg_cohort_num
               # const tttrend

               if (cohort_ex==0)
               {
                  do k = 1,x_cohorts_end+frcstcohorts
                     compute new_beta(%rows(new_beta)-(x_cohorts_end+frcstcohorts-k)) = (%beta(1)+%beta(2)*float(reg_cohort_num+k))
                  end do
               }
               else {
                  do k = 1,x_cohorts_end
                     compute new_beta(%rows(new_beta)-(x_cohorts_end+frcstcohorts-k)) = (%beta(1)+%beta(2)*float(reg_cohort_num+k))
                  end do

                  do k = x_cohorts_end+1,x_cohorts_end+frcstcohorts
                     compute new_beta(%rows(new_beta)-(x_cohorts_end+frcstcohorts-k)) = (%beta(1)+%beta(2)*float(reg_cohort_num+x_cohorts_end))
                  end do
               }
            }
         }
         else {
            if ((x_cohorts_beg>0).or.(smoothed==1))
            {
               do k = 1,x_cohorts_beg+fix(%if(smoothed == 1,1,0))
                  compute new_beta(%rlcount(reglist)+64+k) = new_beta(%rlcount(reglist)+64+x_cohorts_beg+fix(%if(smoothed==1,1,0))+1)
               end do
            }
            if ((x_cohorts_end>0).or.(fyear>eyear))
            {
               do k = 1,x_cohorts_end+frcstcohorts
                  compute new_beta(%rows(new_beta)-(x_cohorts_end+frcstcohorts-k)) = new_beta(%rows(new_beta)-(x_cohorts_end+frcstcohorts))
               end do
            }
         }

         smpl(series=panelsmpl_f)

         compute restrict_num = fix(%if(ce_poly_degree<0, $
                                        x_cohorts_beg+x_cohorts_end, $
                                        lastcohort-firstcohort-ce_poly_degree))+ $
                                fix(%if(ae_poly_degree<0, $
                                        1, $
                                        64-(ae_poly_degree+1)))

         ** SET UP COMPONENT SUBVECTOR (i.e. RHS VARIABLE COEFFICIENTS, AGE EFFECTS,
         ** AND COHORT EFFECT VECTORS)

         compute cevec =   %xsubvec(new_beta, $
                                    %rows(new_beta)-(lastcohort-firstcohort), $
                                    %rows(new_beta))
         compute cevecse = %xsubvec(pre_stderrs, $
                                    %rows(new_beta)-(lastcohort-firstcohort), $
                                    %rows(new_beta))

         compute aevec =   %xsubvec(new_beta, $
                                    %rows(new_beta)-(lastcohort-firstcohort)-%rows(allages), $
                                    %rows(new_beta)-(lastcohort-firstcohort)-1)
         compute aevecse = %xsubvec(pre_stderrs, $
                                    %rows(new_beta)-(lastcohort-firstcohort)-%rows(allages), $
                                    %rows(new_beta)-(lastcohort-firstcohort)-1)

         display ' '; display 'RECREATING REGRESSION OUTPUT...'; display '';
         linreg(create, $
                robusterrors, lags=12, lwindow=neweywest, $ 
                smpl=panelsmpl_f, $
                coeff=new_beta, $
                covmat=pre_xx, $
                regcorr=restrict_num, $
                spread=%s('spread'+genders(s)+'_'+fs), $
                   define=fiteq) %s('ln'+stypes(1)+genders(s)+'p') / %s(genders(s)+'resids_'+fs)
            # reglist %s('age_16_'+fs) to %s('age_79_'+fs) %s('c_'+firstcohort) to %s('c_'+lastcohort)


         display "Centered R**2:   " *.###### %RSQUARED
         display "R BAR **2:       " *.###### %RBARSQ
         display "Uncentered R**2: " *.###### %TRSQ/%NOBS
         display "T x R**2:        " *.###### %TRSQ
      }

      prj(smpl=panelsmpl_f,xvx=%s(genders(s)+'xvx_'+fs)) %s('ln'+stypes(1)+'_fit'+genders(s)+fs)
      compute seesq1 = %seesq
      set %s(genders(s)+'resids1_'+fs) = %s(genders(s)+'resids_'+fs)*boundx
      print / %s(genders(s)+'xvx_'+fs)


      if (errmod==1)
      {
         set %s(genders(s)+'arresids2_'+fs) = %s(genders(s)+'resids_'+fs) - %s(genders(s)+'resids_'+fs){1}*%rho
      }
      else if (errmod==2)
      {
         set %s(genders(s)+'arresids2_'+fs) = %s(genders(s)+'resids_'+fs) - %s(genders(s)+'resids_'+fs){1}*%s('prhos'+genders(s)+'_'+fs)
      }

      if (debug==1)
      {
         if (errmod==1)
         {
            print / %s('ln'+stypes(1)+'_fit'+genders(s)+fs) %s('ln'+stypes(1)+'_arfit'+genders(s)+fs)
            print / %s(genders(s)+'arresids_'+fs) %s(genders(s)+'arresids2_'+fs) %s(genders(s)+'resids_'+fs)
         }
         else if (errmod==2)
         {
            print / %s('ln'+stypes(1)+'_fit'+genders(s)+fs) %s('ln'+stypes(1)+'_arfit'+genders(s)+fs)
            print / %s(genders(s)+'arresids_'+fs) %s(genders(s)+'arresids2_'+fs) %s(genders(s)+'resids_'+fs) %s('prhos'+genders(s)+'_'+fs)
         }
      }

      ** SET UP COMPONENT SUBVECTOR (i.e. RHS VARIABLE COEFFICIENTS, AGE EFFECTS,
      ** AND COHORT EFFECT VECTORS)

      compute cevec =   %xsubvec(new_beta, $
                                 %rows(new_beta)-(lastcohort-firstcohort), $
                                 %rows(new_beta))
      compute cevecse = %xsubvec(pre_stderrs, $
                                 %rows(new_beta)-(lastcohort-firstcohort), $
                                 %rows(new_beta))

      compute aevec =   %xsubvec(new_beta, $
                                 %rows(new_beta)-(lastcohort-firstcohort)-%rows(allages), $
                                 %rows(new_beta)-(lastcohort-firstcohort)-1)
      compute aevecse = %xsubvec(pre_stderrs, $
                                 %rows(new_beta)-(lastcohort-firstcohort)-%rows(allages), $
                                 %rows(new_beta)-(lastcohort-firstcohort)-1)

      **************************************************************************
      **************************************************************************
      ** PRODUCE TREND AND FITTED SERIES
      **************************************************************************

      ** PRODUCE THE 'FITTED' RESIDUALS (i.e. RESIDUALS FOR THE COMPLETE FIT
      ** SERIES - INCLUDING EXTRAPOLATED EFFECTS - IN THEIR ORIGINAL SCALE
      if (logit==1)
      {
         set %s(genders(s)+'residst_'+fs) = 1/(1+exp(-%s('ln'+stypes(1)+genders(s)+'p')))-1/(1+exp(-%s('ln'+stypes(1)+'_fit'+genders(s)+fs)))
      }
      else
      {
         set %s(genders(s)+'residst_'+fs) = %s('ln'+stypes(1)+genders(s)+'p')-%s('ln'+stypes(1)+'_fit'+genders(s)+fs)
      }

      compute nreg = %rlcount(%reglist())
      compute cvect = %zeros(nreg,1)
      ** PRODUCE THE TREND AND FIT SERIES (IN THEIR ORIGINAL SCALES)

      ** EXTRACT CYCLE
      display ''; display 'EXTRACTING CYCLE...'; display ''

      set %s('ln'+stypes(1)+'_cyc'+genders(s)+fs) = 0.0
      compute regind = 0
      do r = 1,%rows(rhsvar)
         if (((rhsvarsex(r)==0).or.(s==rhsvarsex(r))).and.(rhsvarstage(r)==1))
         {
            if (rhsvarcyc(r)==1)
            {
               compute amax = fix(%if(rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5, $
                                      %rows(rhsages(r)),$
                                      %if(rhsvartype(r)==2.or.rhsvartype(r)==6, $
                                          %rows(rhsages(r))/2,$
                                          1))) 
               dofor a=1 to amax
                  compute regind = regind + 1
                  compute cvect(regind,1) = 1
                  set %s('ln'+stypes(1)+'_cyc'+genders(s)+fs) = %s('ln'+stypes(1)+'_cyc'+genders(s)+fs) + new_beta(regind)*reglist(regind){0}
                  if (rhslagl(r)(1)<>0)
                  {
                     dofor l=1 to %rows(rhslagl(r))
                        compute regind = regind + 1
                        compute cvect(regind,1) = 1
                        set %s('ln'+stypes(1)+'_cyc'+genders(s)+fs) = %s('ln'+stypes(1)+'_cyc'+genders(s)+fs) + new_beta(regind)*reglist(regind){0}
                     end dofor
                  }
               end dofor 
            }
            else
            {
               compute regind = regind + $
               fix(%if(rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5, $
                       %rows(rhsages(r)),$
                       %if(rhsvartype(r)==2.or.rhsvartype(r)==6,%rows(rhsages(r))/2,1))* $
                           %if(rhslagl(r)(1)<>0, $
                               (1+%rows(rhslagl(r))), $
                               1))
            }
         }
      end do

      display ''; display 'DONE.'; display ''

      if (logit==1)
      {
         set(smpl=panelsmpl_f) %s(stypes(1)+'_mod'+genders(s)+fs) = 1/(1+exp(-(%s('ln'+stypes(1)+'_fit'+genders(s)+fs)-%s('ln'+stypes(1)+'_cyc'+genders(s)+fs))))
         set(smpl=panelsmpl_f) %s(stypes(1)+'_pred'+genders(s)+fs) = 1/(1+exp(-(%s('ln'+stypes(1)+'_fit'+genders(s)+fs))))
         set(smpl=panelsmpl_f) %s(stypes(1)+'_mod_scale'+genders(s)+fs) = %s(stypes(1)+'_mod'+genders(s)+fs)*(1-%s(stypes(1)+'_mod'+genders(s)+fs))
         set(smpl=panelsmpl_f) %s(stypes(1)+'_pred_scale'+genders(s)+fs) = %s(stypes(1)+'_pred'+genders(s)+fs)*(1-%s(stypes(1)+'_pred'+genders(s)+fs))
      }
      else
      {
         set(smpl=panelsmpl_f) %s(stypes(1)+'_mod'+genders(s)+fs) = %s('ln'+stypes(1)+'_fit'+genders(s)+fs)-%s('ln'+stypes(1)+'_cyc'+genders(s)+fs)
         set(smpl=panelsmpl_f) %s(stypes(1)+'_pred'+genders(s)+fs) = %s('ln'+stypes(1)+'_fit'+genders(s)+fs)
         set(smpl=panelsmpl_f) %s(stypes(1)+'_mod_scale'+genders(s)+fs) = 1.0
         set(smpl=panelsmpl_f) %s(stypes(1)+'_pred_scale'+genders(s)+fs) = 1.0
      }

      ** set up matrices for confidence band calculations
      ** design matrix -- exports the data to a file suitable for doing the calculation in Matlab
      make(smpl=panelsmpl_e,lastreg) xmatrix
      display "Number of rows for xmatrix = " *.# %rows(xmatrix)
      display "Number of cols for xmatrix = " *.# %cols(xmatrix)
      compute tpers = fix(%rows(xmatrix)/64)

      display "Making pdiag..."
      make(smpl=panelsmpl_e) pdiag
      # %s(stypes(1)+'_pred_scale'+genders(s)+fs)

      display "Done. Making mdiag..."
      make(smpl=panelsmpl_e) mdiag
      # %s(stypes(1)+'_mod_scale'+genders(s)+fs)

      display "Done. Stacking pdiag and mdiag..."
      compute adiag = pdiag ~~ mdiag; *vertical concatenation

      make(smpl=panelsmpl_e) popmat 
      # %s(stypes(3)+genders(s)+'p')

      make(smpl=panelsmpl_e) spreadmat
      # %s('spread'+genders(s)+'_'+fs)

      make(smpl=panelsmpl_e) lfpr
      # %s(stypes(1)+genders(s)+'p')

      * write adiag, cvect, xmatrix, %xx, popmat matrices and %seesq scalar to Matlab
      compute matfile = "/tmp/matout_g"+genders(s)+"_f"+fs+"_run"+%string(runno)+".mat"
      dos "rm -f "+matfile
      open matout &matfile
      * write adiag
      display "Writing adiag..."
      display(unit=matout) "adiag = [..."
      do i = 1,(%rows(adiag)-1)
         display(unit=matout) *.############### adiag(i,1) @-1 ",..."
      end do
      display(unit=matout) *.############### adiag(%rows(adiag),1) @-1 "];"
      * write cvect
      display "Done.  Writing cvect..."
      display(unit=matout) "cvect = [..."
      do i = 1,(%rows(cvect)-1)
         display(unit=matout) *.############### cvect(i,1) @-1 ",..."
      end do
      display(unit=matout) *.############### cvect(%rows(cvect),1) @-1 "];"
      * write xmatrix
      display "Done.  Writing xmatrix..."
      display(unit=matout) "xmatrix = [..."
      do i = 1,%rows(xmatrix)
         do j = 1,(%cols(xmatrix)-1)
            display(unit=matout) *.############### xmatrix(i,j) @-1 ",..."
         end do
         if (i==%rows(xmatrix))
         {
            display(unit=matout) *.############### xmatrix(i,%cols(xmatrix)) @-1 "];"
         }
         else
         {
            display(unit=matout) *.############### xmatrix(i,%cols(xmatrix)) @-1 ";..."
         }
      end do
      * write %xx
      display "Done.  Writing %xx..."
      display(unit=matout) "xx = [..."
      do i = 1,%rows(%xx)
         do j = 1,(%cols(%xx)-1)
            display(unit=matout) *.############### %xx(i,j) @-1 ",..."
         end do
         if (i==%rows(%xx))
         {
            display(unit=matout) *.############### %xx(i,%cols(%xx)) @-1 "];"
         }
         else
         {
            display(unit=matout) *.############### %xx(i,%cols(%xx)) @-1 ";..."
         }
      end do
      * write popmat
      display "Done.  Writing popmat..."
      display(unit=matout) "popmat = [..."
      do i = 1,%rows(popmat)
         do j = 1,(%cols(popmat)-1)
            display(unit=matout) *.############### popmat(i,j) @-1 ",..."
         end do
         if (i==%rows(popmat))
         {
            display(unit=matout) *.############### popmat(i,%cols(popmat)) @-1 "];"
         }
         else
         {
            display(unit=matout) *.############### popmat(i,%cols(popmat)) @-1 ";..."
         }
      end do
      * write spreadmat
      display "Done.  Writing spreadmat..."
      display(unit=matout) "spreadmat = [..."
      do i = 1,%rows(spreadmat)
         do j = 1,(%cols(spreadmat)-1)
            display(unit=matout) *.############### spreadmat(i,j) @-1 ",..."
         end do
         if (i==%rows(spreadmat))
         {
            display(unit=matout) *.############### spreadmat(i,%cols(spreadmat)) @-1 "];"
         }
         else
         {
            display(unit=matout) *.############### spreadmat(i,%cols(spreadmat)) @-1 ";..."
         }
      end do
      * write %seesq
      display "Done.  Writing %seesq..."
      display(unit=matout) "seesq = " *.############### %seesq @-1 ";"
      display "All done!"
      close matout

      compute ceavg = %avg(cevec)
      compute cemed = (%sort(cevec))(fix(%round((lastcohort-firstcohort+1)/2,0)),1)
      compute cemin = %minvalue(cevec)
      compute cemax = %maxvalue(cevec)
      compute aeavg = %avg(aevec)
      compute aemed = (%sort(aevec))(32,1)
      compute aemin = %minvalue(aevec)
      compute aemax = %maxvalue(aevec)
      compute ae25  = (%sort(aevec))(16,1)
      compute ae75  = (%sort(aevec))(48,1)

      calendar firstcohort 1 1
      allocate lastcohort-firstcohort+1
      clear %s('ce'+genders(s)+fs) %s('ceavg'+genders(s)+fs)
      clear %s('cemed'+genders(s)+fs) %s('cemin'+genders(s)+fs)
      clear %s('cemax'+genders(s)+fs) %s('ce25'+genders(s)+fs)
      clear %s('ce75'+genders(s)+fs)

      if (logit==1)
      {
         dofor c=1 to (lastcohort-firstcohort+1)
            compute %s('ce'+genders(s)+fs)(c) = exp(cevec(c))
            compute %s('ceavg'+genders(s)+fs)(c) = 1/(1+exp(-cevec(c)-aeavg))
            compute %s('cemed'+genders(s)+fs)(c) = 1/(1+exp(-cevec(c)-aemed))
            compute %s('cemin'+genders(s)+fs)(c) = 1/(1+exp(-cevec(c)-aemin))
            compute %s('cemax'+genders(s)+fs)(c) = 1/(1+exp(-cevec(c)-aemax))
            compute %s('ce25'+genders(s)+fs)(c) = 1/(1+exp(-cevec(c)-ae25))
            compute %s('ce75'+genders(s)+fs)(c) = 1/(1+exp(-cevec(c)-ae75))
         end dofor 
      }
      else 
      {
         dofor c=1 to (lastcohort-firstcohort+1)
            compute %s('ce'+genders(s)+fs)(c) = cevec(c)
            compute %s('ceavg'+genders(s)+fs)(c) = cevec(c)+aeavg
            compute %s('cemed'+genders(s)+fs)(c) = cevec(c)+aemed
            compute %s('cemin'+genders(s)+fs)(c) = cevec(c)+aemin
            compute %s('cemax'+genders(s)+fs)(c) = cevec(c)+aemax
            compute %s('ce25'+genders(s)+fs)(c) = cevec(c)+ae25
            compute %s('ce75'+genders(s)+fs)(c) = cevec(c)+ae75
         end dofor 
      }

      open(append) copy &lfproutfile
         copy(format=fame) firstcohort:1 lastcohort:1 $
         %s('ce'+genders(s)+fs) to %s('ce75'+genders(s)+fs)
      close copy


      calendar(irregular)
      allocate 64

      clear %s('stage2age'+genders(s)+fs) %s('ages'+fs) %s('ae'+genders(s)+fs)
      clear %s('aeavg'+genders(s)+fs) %s('aemin'+genders(s)+fs)
      clear %s('aemax'+genders(s)+fs) %s('aemed'+genders(s)+fs)

      if (logit==1)
      {
         do i=1,64
            compute %s('ae'+genders(s)+fs)(i) = aevec(i)
            compute %s('aeavg'+genders(s)+fs)(i) = 1/(1+exp(-aevec(i)-ceavg))
            compute %s('aemin'+genders(s)+fs)(i) = 1/(1+exp(-aevec(i)-cemin))
            compute %s('aemax'+genders(s)+fs)(i) = 1/(1+exp(-aevec(i)-cemax))
            compute %s('aemed'+genders(s)+fs)(i) = 1/(1+exp(-aevec(i)-cemed))
            compute %s('stage2age'+genders(s)+fs)(i) = stage2age(i)
            compute %s('ages'+fs)(i) = i+15   
         end do
      }
      else
      {
         do i=1,64
            compute %s('ae'+genders(s)+fs)(i) = aevec(i)
            compute %s('aeavg'+genders(s)+fs)(i) = aevec(i)+ceavg
            compute %s('aemin'+genders(s)+fs)(i) = aevec(i)+cemin
            compute %s('aemax'+genders(s)+fs)(i) = aevec(i)+cemax
            compute %s('aemed'+genders(s)+fs)(i) = aevec(i)+cemed
            compute %s('stage2age'+genders(s)+fs)(i) = stage2age(i)
            compute %s('ages'+fs)(i) = i+15   
         end do

      }

      display ''; display 'CREATING COEFFICIENT SERIES...'; display ''

      compute regind = 0
      compute minr = 0
      compute maxr = 0
      dofor r=1 to %rows(rhsvar) 
         if (((rhsvarsex(r)==0).or.(s==rhsvarsex(r))).and.(rhsvarstage(r)==1))
         {
            if minr==0; compute minr=r
            compute maxr=r

            set %s(rhsvar(r)+'c'+genders(s)+fs) = %NA
            set %s(rhsvar(r)+'e'+genders(s)+fs) = %NA
            if (rhslagl(r)(1)<>0)
            {
               dofor l=1 to %rows(rhslagl(r))
                  set %s(rhsvar(r)+'c'+fix(rhslagl(r)(l))+genders(s)+fs) = %NA
                  set %s(rhsvar(r)+'e'+fix(rhslagl(r)(l))+genders(s)+fs) = %NA
               end dofor
            }

            if (rhsvartype(r)==2.or.rhsvartype(r)==6)
            {
               dofor g=1 to %rows(rhsages(r))/2
                  compute regind=regind+1
                  dofor a=rhsages(r)(2*g-1) to rhsages(r)(2*g)
                     compute %s(rhsvar(r)+'c'+genders(s)+fs)(a-15) = new_beta(regind)
                     compute %s(rhsvar(r)+'e'+genders(s)+fs)(a-15) = pre_stderrs(regind)
                     if (rhslagl(r)(1)<>0)
                     {
                        dofor l=1 to %rows(rhslagl(r))
                           compute %s(rhsvar(r)+'c'+fix(rhslagl(r)(l))+genders(s)+fs)(a-15) = new_beta(regind+l)
                           compute %s(rhsvar(r)+'e'+fix(rhslagl(r)(l))+genders(s)+fs)(a-15) = pre_stderrs(regind+l)
                        end dofor
                     }
                  end dofor
                  compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
               end dofor                  
            }
            else
            {
               if (rhsvartype(r)==3); compute regind=regind+1
               dofor a = 1 to %rows(rhsages(r))
                  if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+1
                  compute %s(rhsvar(r)+'c'+genders(s)+fs)(rhsages(r)(a)-15) = new_beta(regind)
                  compute %s(rhsvar(r)+'e'+genders(s)+fs)(rhsages(r)(a)-15) = pre_stderrs(regind)
                  if (rhslagl(r)(1)<>0)
                  {
                     dofor l=1 to %rows(rhslagl(r))
                        compute %s(rhsvar(r)+'c'+fix(rhslagl(r)(l))+genders(s)+fs)(rhsages(r)(a)-15) = new_beta(regind+l)
                        compute %s(rhsvar(r)+'e'+fix(rhslagl(r)(l))+genders(s)+fs)(rhsages(r)(a)-15) = pre_stderrs(regind+l)
                     end dofor
                     if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+%rows(rhslagl(r))
                  }
               end dofor
               if (rhsvartype(r)==3); compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
            }
         }
      end dofor

      display ''; display 'DONE.'; display ''

      if (errmod==1)
      {
         clear %s('rho'+genders(s)+fs)
         set %s('rho'+genders(s)+fs) = %rho
         if (debug==1)
         {
            print / %s('rho'+genders(s)+fs)
         }
      }
      else if (errmod==2)
      {
         clear %s('rho'+genders(s)+fs)
         dofor a = 1 to 64
            compute %s('rho'+genders(s)+fs)(a) = %s('prhos'+genders(s)+'_'+fs)(fix(1+(a-1)*pnobs_lags))
         end dofor
         if (debug==1)
         {
            print / %s('rho'+genders(s)+fs)
         }
      }

      open(append) copy &lfproutfile
         copy(format=fame) 1 64 %s('stage2age'+genders(s)+fs) %s('ages'+fs) %s('ae'+genders(s)+fs) to %s('aemed'+genders(s)+fs)

         if (rhslagl(maxr)(1)<>0)
         {
            copy(format=fame) 1 64 %s(rhsvar(minr)+'c'+genders(s)+fs) to $
                                   %s(rhsvar(maxr)+'e'+fix(rhslagl(maxr)(%rows(rhslagl(maxr))))+genders(s)+fs)
         }  
         else
         {
            copy(format=fame) 1 64 %s(rhsvar(minr)+'c'+genders(s)+fs) to $
                                   %s(rhsvar(maxr)+'e'+genders(s)+fs)
         }
         if ((errmod==1).or.(errmod==2))
         {
            copy(format=fame) 1 64 %s('rho'+genders(s)+fs)
         }            
      close copy

      *******
      ** SET SERIES TO EXPORT TO FAME DATABASE
      *******
      calendar syear sper npers
      allocate 2020:npers   

      dos "rm -f "+tempfile2
      open fameout &tempfile2
      display(unit=fameout) "open <ac up> "+'"'+lfproutfile+'"'+" as lout"
      display(unit=fameout) "over on"

      display(unit=fameout) "scalar lout'seesq"+genders(s)+"_"+fs+":precision = " *.############### seesq1

      do i=1,64
         ** AGE EFFECT SERIES (EXPONENTIATED)
         if (logit==1)
         {
            set %s('ae'+genders(s)+allages(i)+fs) = exp(aevec(i))
         }
         else
         {
            set %s('ae'+genders(s)+allages(i)+fs) = aevec(i)
         }
         display(unit=fameout) "scalar lout'ae"+genders(s)+allages(i)+fs+":precision = " *.############### exp(aevec(i))
         ** AGE EFFECT STANDARAD ERROR SERIES (RAW)
         set %s('aese'+genders(s)+allages(i)+fs) = aevecse(i)
         display(unit=fameout) "scalar lout'aese"+genders(s)+allages(i)+fs+":precision = " *.############### aevecse(i)
      end do
      do i=firstcohort,lastcohort
         ** COHORT EFFECT SERIES (EXPONENTIATED)      
         if (logit==1)
         {
            set %s('ce'+genders(s)+(i-1000)+fs) = exp(cevec(i-firstcohort + 1))
         }
         else
         {
            set %s('ce'+genders(s)+(i-1000)+fs) = cevec(i-firstcohort + 1)
         }
         display(unit=fameout) "scalar lout'ce"+genders(s)+(i-1000)+fs+":precision = " *.############### exp(cevec(i-firstcohort+1))
         ** COHORT EFFECT STANDARD ERROR SERIES (RAW)
         set %s('cese'+genders(s)+(i-1000)+fs) = cevecse(i-firstcohort + 1)
         display(unit=fameout) "scalar lout'cese"+genders(s)+(i-1000)+fs+":precision = " *.############### cevecse(i-firstcohort+1)
      end do
      
      compute regind = 0
      dofor r=1 to %rows(rhsvar)
         if (((rhsvarsex(r)==0).or.(s==rhsvarsex(r))).and.(rhsvarstage(r)==1))
         {
            if (rhsvartype(r)==2.or.rhsvartype(r)==6)
            {
               dofor g=1 to %rows(rhsages(r))/2
                  compute regind=regind+1
                  dofor a=rhsages(r)(2*g-1) to rhsages(r)(2*g)
                     display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+genders(s)+a+fs+":precision = " *.############### new_beta(regind)
                     display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+genders(s)+a+fs+":precision = " *.############### pre_stderrs(regind)
                     if (rhslagl(r)(1)<>0)
                     {
                        dofor l=1 to %rows(rhslagl(r))
                            display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+fix(rhslagl(r)(l))+genders(s)+a+fs+":precision = " *.############### new_beta(regind+l)
                            display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+fix(rhslagl(r)(l))+genders(s)+a+fs+":precision = " *.############### pre_stderrs(regind+l)
                        end dofor
                     }
                  end dofor
                  compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
               end dofor
            }
            else
            { 
               if (rhsvartype(r)==3); compute regind=regind+1
               dofor a = 1 to %rows(rhsages(r))
                  if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+1
                  display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### new_beta(regind)
                  display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### pre_stderrs(regind)
                  if (rhslagl(r)(1)<>0)
                  {
                     dofor l=1 to %rows(rhslagl(r))
                        display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+fix(rhslagl(r)(l))+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### new_beta(regind+l)
                        display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+fix(rhslagl(r)(l))+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### pre_stderrs(regind+l)
                     end dofor
                  }
                  if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
               end dofor
               if (rhsvartype(r)==3); compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
            }
         }
      end dofor

      display(unit=fameout) " "
      display(unit=fameout) "close lout"
      display(unit=fameout) "exit"

      close fameout

      dos "fame -fame i "+tempfile2
      *dos "rm -f "+tempfile2

      if (dostage2==1)
      {
         calendar(recall=panel_cal_lags)
         allocate 64//fyear:fper         

         display ' '; display 'RUNNING SECOND STAGE REGRESSION...'; display '';

         * SET THE APPROPRIATE REGRESSION LIST BASED ON SEX
         if (s==1); compute reglist = reglistf2; else; compute reglist=reglistm2;

         if ((errmod==1).or.(errmod==2))
         {
            linreg(smpl=panelsmpl_f, $
               spread=%s('spread'+genders(s)+'_'+fs)) %s(genders(s)+'arresids2_'+fs) / %s(genders(s)+'resids2_'+fs)
            # reglist
         }
         else
         {
            linreg(smpl=panelsmpl_f, $
               spread=%s('spread'+genders(s)+'_'+fs)) %s(genders(s)+'resids_'+fs) / %s(genders(s)+'resids2_'+fs) 
            # reglist
         }

         prj(smpl=panelsmpl_f,xvx=%s(genders(s)+'xvx2_'+fs)) %s('ln'+stypes(1)+'_fit2'+genders(s)+fs)
         print / %s(genders(s)+'xvx2_'+fs)
         ** PRODUCE THE TREND AND FIT SERIES (IN THEIR ORIGINAL SCALES)

         ** EXTRACT CYCLE
         set %s('ln'+stypes(1)+'_cyc2'+genders(s)+fs) = 0.0
         compute regind = 0
         do r = 1,%rows(rhsvar)
            if (((rhsvarsex(r)==0).or.(s==rhsvarsex(r))).and.(rhsvarstage(r)==2))
            {
               if (rhsvarcyc(r)==1)
               {
                  compute amax = fix(%if(rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5, $
                                         %rows(rhsages(r)),$
                                         %if(rhsvartype(r)==2.or.rhsvartype(r)==6, $
                                             %rows(rhsages(r))/2,$
                                             1))) 

                  dofor a=1 to amax
                     compute regind = regind + 1
                     set %s('ln'+stypes(1)+'_cyc2'+genders(s)+fs) = %s('ln'+stypes(1)+'_cyc2'+genders(s)+fs) + %beta(regind)*reglist(regind){0}
                     if (rhslagl(r)(1)<>0)
                     {
                        dofor l=1 to %rows(rhslagl(r))
                           compute regind = regind + 1
                           set %s('ln'+stypes(1)+'_cyc2'+genders(s)+fs) = %s('ln'+stypes(1)+'_cyc2'+genders(s)+fs) + %beta(regind)*reglist(regind){0}
                        end dofor l
                     }
                  end dofor 
               }
               else
               {
                  compute regind = regind + $
                  fix(%if(rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5, $
                         %rows(rhsages(r)), $
                         %if(rhsvartype(r)==2.or.rhsvartype(r)==6,%rows(rhsages(r))/2,1))* $
                            %if(rhslagl(r)(1)<>0, $
                                (1+%rows(rhslagl(r))), $
                                1))
               }
            }
         end do

         if (logit==1)
         {
            set(smpl=panelsmpl_f) %s(stypes(1)+'_mod'+genders(s)+fs) = 1/(1+exp(-(%s('ln'+stypes(1)+'_fit'+genders(s)+fs)-%s('ln'+stypes(1)+'_cyc'+genders(s)+fs)+ $
                                                                                   %s('ln'+stypes(1)+'_fit2'+genders(s)+fs)-%s('ln'+stypes(1)+'_cyc2'+genders(s)+fs))))
            set(smpl=panelsmpl_f) %s(stypes(1)+'_pred'+genders(s)+fs) = 1/(1+exp(-(%s('ln'+stypes(1)+'_fit'+genders(s)+fs)+%s('ln'+stypes(1)+'_fit2'+genders(s)+fs))))
         }
         else
         {
            set(smpl=panelsmpl_f) %s(stypes(1)+'_mod'+genders(s)+fs) = %s('ln'+stypes(1)+'_fit'+genders(s)+fs)-%s('ln'+stypes(1)+'_cyc'+genders(s)+fs)+ $
                                                                        %s('ln'+stypes(1)+'_fit2'+genders(s)+fs)-%s('ln'+stypes(1)+'_cyc2'+genders(s)+fs)
            set(smpl=panelsmpl_f) %s(stypes(1)+'_pred'+genders(s)+fs) = %s('ln'+stypes(1)+'_fit'+genders(s)+fs)+%s('ln'+stypes(1)+'_fit2'+genders(s)+fs)
         }

         calendar(irregular)
         allocate 64

         compute regind = 0
         compute minr = 0
         compute maxr = 0
         dofor r=1 to %rows(rhsvar) 
            if (((rhsvarsex(r)==0).or.(s==rhsvarsex(r))).and.(rhsvarstage(r)==2))
            {
               if minr==0; compute minr=r
               compute maxr=r

               set %s(rhsvar(r)+'c'+genders(s)+fs) = %NA
               set %s(rhsvar(r)+'e'+genders(s)+fs) = %NA
               if (rhslagl(r)(1)<>0)
               {
                  dofor l=1 to %rows(rhslagl(r))
                     set %s(rhsvar(r)+'c'+fix(rhslagl(r)(l))+genders(s)+fs) = %NA
                     set %s(rhsvar(r)+'e'+fix(rhslagl(r)(l))+genders(s)+fs) = %NA
                  end dofor
               }

               if (rhsvartype(r)==2.or.rhsvartype(r)==6)
               {
                  dofor g=1 to %rows(rhsages(r))/2
                     compute regind=regind+1
                     dofor a=rhsages(r)(2*g-1) to rhsages(r)(2*g)
                        compute %s(rhsvar(r)+'c'+genders(s)+fs)(a-15) = %beta(regind)
                        compute %s(rhsvar(r)+'e'+genders(s)+fs)(a-15) = %stderrs(regind)
                        if (rhslagl(r)(1)<>0)
                        {
                           dofor l=1 to %rows(rhslagl(r))
                              compute %s(rhsvar(r)+'c'+fix(rhslagl(r)(l))+genders(s)+fs)(a-15) = %beta(regind+l)
                              compute %s(rhsvar(r)+'e'+fix(rhslagl(r)(l))+genders(s)+fs)(a-15) = %stderrs(regind+l)
                           end dofor
                        }
                     end dofor
                     compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
                  end dofor 
               }
               else
               {
                  if (rhsvartype(r)==3); compute regind=regind+1
                  dofor a = 1 to %rows(rhsages(r))
                     if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+1
                     compute %s(rhsvar(r)+'c'+genders(s)+fs)(rhsages(r)(a)-15) = %beta(regind)
                     compute %s(rhsvar(r)+'e'+genders(s)+fs)(rhsages(r)(a)-15) = %stderrs(regind)
                     if (rhslagl(r)(1)<>0)
                     {
                        dofor l=1 to %rows(rhslagl(r))
                           compute %s(rhsvar(r)+'c'+fix(rhslagl(r)(l))+genders(s)+fs)(rhsages(r)(a)-15) = %beta(regind+l)
                           compute %s(rhsvar(r)+'e'+fix(rhslagl(r)(l))+genders(s)+fs)(rhsages(r)(a)-15) = %stderrs(regind+l)
                        end dofor
                        if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+%rows(rhslagl(r))
                     }
                  end dofor
                  if (rhsvartype(r)==3); compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
               }
            }
         end dofor

         open(append) copy &lfproutfile
            if (rhslagl(maxr)(1)<>0)
            {
               copy(format=fame) 1 64 %s(rhsvar(minr)+'c'+genders(s)+fs) to $
                                      %s(rhsvar(maxr)+'e'+fix(rhslagl(maxr)(%rows(rhslagl(maxr))))+genders(s)+fs)
            }  
            else
            {
               copy(format=fame) 1 64 %s(rhsvar(minr)+'c'+genders(s)+fs) to $
                                      %s(rhsvar(maxr)+'e'+genders(s)+fs)
            }
         close copy

         *******
         ** SET SERIES TO EXPORT TO FAME DATABASE
         *******
         calendar syear sper npers
         allocate 2020:npers   

         dos "rm -f "+tempfile3
         open fameout &tempfile3
         display(unit=fameout) "open <ac up> "+'"'+lfproutfile+'"'+" as lout"
         display(unit=fameout) "over on"
 
         compute regind = 0
         dofor r=1 to %rows(rhsvar)
            if (((rhsvarsex(r)==0).or.(s==rhsvarsex(r))).and.(rhsvarstage(r)==2))
            {
               if (rhsvartype(r)==2.or.rhsvartype(r)==6)
               {
                  dofor g=1 to %rows(rhsages(r))/2
                     compute regind=regind+1
                     dofor a=rhsages(r)(2*g-1) to rhsages(r)(2*g)
                        display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+genders(s)+a+fs+":precision = " *.############### new_beta(regind)
                        display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+genders(s)+a+fs+":precision = " *.############### pre_stderrs(regind)
                        if (rhslagl(r)(1)<>0)
                        {
                           dofor l=1 to %rows(rhslagl(r))
                              display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+fix(rhslagl(r)(l))+genders(s)+a+fs+":precision = " *.############### new_beta(regind+l)
                              display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+fix(rhslagl(r)(l))+genders(s)+a+fs+":precision = " *.############### pre_stderrs(regind+l)
                           end dofor
                        }
                     end dofor
                     compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
                  end dofor
               }
               else
               {
                  if (rhsvartype(r)==3); compute regind=regind+1
                  dofor a = 1 to %rows(rhsages(r))
                     if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+1
                     display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### %beta(regind)
                     display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### %stderrs(regind)
                     if (rhslagl(r)(1)<>0)
                     {
                        dofor l=1 to %rows(rhslagl(r))
                           display(unit=fameout) "scalar lout'"+rhsvar(r)+"c"+fix(rhslagl(r)(l))+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### %beta(regind+l)
                           display(unit=fameout) "scalar lout'"+rhsvar(r)+"e"+fix(rhslagl(r)(l))+genders(s)+rhsages(r)(a)+fs+":precision = " *.############### %stderrs(regind+l)
                        end dofor
                     }
                     if (rhsvartype(r)==0.or.rhsvartype(r)==1.or.rhsvartype(r)==4.or.rhsvartype(r)==5); compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
                  end dofor
                  if (rhsvartype(r)==3); compute regind=regind+fix(%if(rhslagl(r)(1)<>0,%rows(rhslagl(r)),0))
               }
            }
         end dofor
 
         display(unit=fameout) " "
         display(unit=fameout) "close lout"
         display(unit=fameout) "exit"
 
         close fameout

         dos "fame -fame i "+tempfile3
         *dos "rm -f "+tempfile3

      }
      show memory
      calendar(recall=panel_cal_lags) 
      allocate 64//fyear:fper
      smpl

      ** calculate age trends -- just for graphing later
      do age=16,79
         clear %s(stypes(1)+'_mod'+genders(s)+age+fs)
         clear %s(stypes(1)+'_pred'+genders(s)+age+fs)
         clear %s('xvx_'+genders(s)+age+fs)
         clear %s('res'+genders(s)+age+fs)
         clear %s('res1'+genders(s)+age+fs)
         do ti = syear:sper, fyear:fper
            compute %s(stypes(1)+'_mod'+genders(s)+age+fs)(1//ti) = %s(stypes(1)+'_mod'+genders(s)+fs)((age-15)//ti)
            compute %s(stypes(1)+'_pred'+genders(s)+age+fs)(1//ti) = %s(stypes(1)+'_pred'+genders(s)+fs)((age-15)//ti)
            compute %s('xvx_'+genders(s)+age+fs)(1//ti) = %s(genders(s)+'xvx_'+fs)((age-15)//ti)
            compute %s('res'+genders(s)+age+fs)(1//ti) = %s(genders(s)+'resids_'+fs)((age-15)//ti)
            compute %s('res1'+genders(s)+age+fs)(1//ti) = %s(genders(s)+'resids1_'+fs)((age-15)//ti)
         end do
      end do

      open(append) copy &lfproutfile
         copy(format=fame) syear:sper fyear:fper $
         %s(stypes(1)+'_mod'+genders(s)+'16'+fs) to %s('res1'+genders(s)+'79'+fs)
      close copy

      if ((errmod==1).or.(errmod==2))
      {
         do age=16,79
            clear %s('arres'+genders(s)+age+fs)
            clear %s('arres1'+genders(s)+age+fs)
            do ti = syear:sper, fyear:fper
               compute %s('arres'+genders(s)+age+fs)(1//ti) = %s(genders(s)+'arresids2_'+fs)((age-15)//ti)
               compute %s('arres1'+genders(s)+age+fs)(1//ti) = %s(genders(s)+'arresids_'+fs)((age-15)//ti)
            end do
         end do

         open(append) copy &lfproutfile
            copy(format=fame) syear:sper fyear:fper %s('arres'+genders(s)+'16'+fs) to %s('arres1'+genders(s)+'79'+fs)
         close copy
      }

      if (dostage2==1)
      {
         do age=16,79
            clear %s('res2'+genders(s)+age+fs)
            do ti = syear:sper, fyear:fper
               compute %s('res2'+genders(s)+age+fs)(1//ti) = %s(genders(s)+'resids2_'+fs)((age-15)//ti)
            end do
         end do

         open(append) copy &lfproutfile
            copy(format=fame) syear:sper fyear:fper %s('res2'+genders(s)+'16'+fs) to %s('res2'+genders(s)+'79'+fs)
         close copy
      }

      calendar syear sper npers
      allocate eyear:eper

      display ' '; display 'COMPUTING RESIDUAL CORRELATIONS...'; display '';
      do age=16,79
         * print / %s('res1'+genders(s)+age+fs)
         correlate(number=2*npers, $
                   organization=columns, $
                   results=%s('corr'+genders(s)+age+fs), $
                   partial=%s('pcorr'+genders(s)+age+fs), $
                   stderrs=%s('corrse'+genders(s)+age+fs)) %s('res1'+genders(s)+age+fs)
         * print / %s('corr'+genders(s)+age+fs) %s('corrse'+genders(s)+age+fs)
 
         if ((errmod==1).or.(errmod==2))
         {
            * print / %s('arres1'+genders(s)+age+fs)
            correlate(number=2*npers, $
                      organization=columns, $
                      results=%s('arcorr'+genders(s)+age+fs), $
                      partial=%s('arpcorr'+genders(s)+age+fs), $
                      stderrs=%s('arcorrse'+genders(s)+age+fs)) %s('arres1'+genders(s)+age+fs)
         }

         if (dostage2==1)
         {
            correlate(number=2*npers, $
                      organization=columns, $
                      results=%s('corr2'+genders(s)+age+fs), $
                      partial=%s('pcorr2'+genders(s)+age+fs), $
                      stderrs=%s('corr2se'+genders(s)+age+fs)) %s('res2'+genders(s)+age+fs)
         }
      end do      

      calendar(irregular)
      allocate 2*npers+1

      open(append) copy &lfproutfile
         copy(format=fame) 1 (2*npers+1) %s('corr'+genders(s)+'16'+fs) to %s('corrse'+genders(s)+'79'+fs)
      close copy

      if ((errmod==1).or.(errmod==2))   
      {
         open(append) copy &lfproutfile
            copy(format=fame) 1 (2*npers+1) %s('arcorr'+genders(s)+'16'+fs) to %s('arcorrse'+genders(s)+'79'+fs)
         close copy
      }

      if (dostage2==1)
      {
         open(append) copy &lfproutfile
            copy(format=fame) 1 (2*npers+1) %s('corr2'+genders(s)+'16'+fs) to %s('corr2se'+genders(s)+'79'+fs)
         close copy
      }
       
      calendar(recall=panel_cal_lags)
      allocate 64//fyear:fper
      smpl(series=panelsmpl_f)

      if (s==1)
      {
         set %s('aggtrend'+fs) = 0.0
         set %s('agg'+fs) = 0.0
         set %s('aggpred'+fs) = 0.0
         set %s('aggtrendx'+fs) = 0.0
         set %s('aggx'+fs) = 0.0
         set %s('aggpredx'+fs) = 0.0
      }
      set %s('aggtrend'+genders(s)+fs) = 0.0
      set %s('agg'+genders(s)+fs) = 0.0
      set %s('aggpred'+genders(s)+fs) = 0.0
      set %s('aggtrendx'+genders(s)+fs) = 0.0
      set %s('aggx'+genders(s)+fs) = 0.0
      set %s('aggpredx'+genders(s)+fs) = 0.0
      
      do i = 1,64
         do ti = syear:sper, fyear:fper
            compute %s('aggtrend'+fs)(1//ti) = $
                    %s('aggtrend'+fs)(1//ti) $
                    + %s(stypes(3)+genders(s)+'p')(i//ti)*%s(stypes(1)+'_mod'+genders(s)+fs)(i//ti)
            compute %s('agg'+fs)(1//ti) = $
                    %s('agg'+fs)(1//ti) $
                    + %s(stypes(3)+genders(s)+'p')(i//ti)*%s(stypes(1)+genders(s)+'p')(i//ti)
            compute %s('aggpred'+fs)(1//ti) = $
                    %s('aggpred'+fs)(1//ti) $
                    + %s(stypes(3)+genders(s)+'p')(i//ti)*%s(stypes(1)+'_pred'+genders(s)+fs)(i//ti)

            compute %s('aggtrend'+genders(s)+fs)(1//ti) = $
                    %s('aggtrend'+genders(s)+fs)(1//ti) $
                    + %s(stypes(2)+genders(s)+'p')(i//ti)*%s(stypes(1)+'_mod'+genders(s)+fs)(i//ti)
            compute %s('agg'+genders(s)+fs)(1//ti) = $
                    %s('agg'+genders(s)+fs)(1//ti) $
                    + %s(stypes(2)+genders(s)+'p')(i//ti)*%s(stypes(1)+genders(s)+'p')(i//ti)
            compute %s('aggpred'+genders(s)+fs)(1//ti) = $
                    %s('aggpred'+genders(s)+fs)(1//ti) $
                    + %s(stypes(2)+genders(s)+'p')(i//ti)*%s(stypes(1)+'_pred'+genders(s)+fs)(i//ti)
         end do
      end do

      if (s==2)
      {
         set %s('agggap'+fs) = (%s('agg'+fs) - %s('aggtrend'+fs))*100
      }

      calendar syear_lags sper_lags npers 
      allocate fyear:fper

      open(append) copy &lfproutfile
         copy(format=fame) syear:sper fyear:fper $
            %s('aggtrend'+genders(s)+fs) %s('agg'+genders(s)+fs) %s('aggpred'+genders(s)+fs)
      close copy

      if (s==2)
      {
         open(append) copy &lfproutfile
            copy(format=fame) syear:sper fyear:fper %s('aggtrend'+fs) %s('agg'+fs) %s('aggpred'+fs) %s('agggap'+fs)
         close copy
      }

      ** RESET THE CALENDAR AND ALLOCATE INSTRUCTIONS TO VALUES THEY HAD BEFORE
      ** THE START OF GENDER LOOP SO THAT NEW SERIES WILL BE CONSTRUCTED CORRECTLY
      ** FOR MEN
      calendar(recall=panel_cal_lags)
      allocate 64//fyear:fper
      smpl

      show memory
   end dofor; * END GENDER LOOP

   ********************************************
   ** produce some graphs to visualize results
   ********************************************
   
   smpl 1//syear:sper 1//fyear:fper
   
   set %s('aggres'+fs) = %s('agg'+fs) - %s('aggpred'+fs)
   set %s('aggresm'+fs) = %s('aggm'+fs) - %s('aggpredm'+fs)
   set %s('aggresf'+fs) = %s('aggf'+fs) - %s('aggpredf'+fs)
   set %s('aggresx'+fs) = %s('aggx'+fs) - %s('aggpredx'+fs)
   set %s('aggresxm'+fs) = %s('aggxm'+fs) - %s('aggpredxm'+fs)
   set %s('aggresxf'+fs) = %s('aggxf'+fs) - %s('aggpredxf'+fs)

   open(append) copy &lfproutfile
      copy(format=fame) 1//syear:sper 1//fyear:fper $
      %s('aggres'+fs) %s('aggresm'+fs) %s('aggresf'+fs)
   close copy

end dofor; * end frequency loop

show memory

halt "Done"
